/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: OCF CardIDFilter sample using ATR.
 *
 */

package ocfbundle;

import java.util.Enumeration;
import java.util.Hashtable;

import opencard.core.service.CardIDFilter;
import opencard.core.terminal.CardID;

/**
 * AtrFilter class
 * This class performs card filterng using ATR and ATR mask.
 * 
 * AtrFilterクラス
 * ATRとビットマスクを使用して、カードフィルタリングします。
 * 
 */
class AtrFilter implements CardIDFilter{
	
	/**
	 * The HashTable which stores card ATR masks and corresponding card ATRs as key/value pairs.
	 * 
	 * ビットマスクがキーで、ATRが値のハッシュテーブル。
	 */
	private Hashtable hashTable = new Hashtable();
	
	/**
	 * Constructs a new AtrFilter object.
	 * 
	 * AtrFilterオブジェクトを構築します。
	 */
	public AtrFilter(){}
	
	/**
	 * Puts a card ATR mask and a card ATR to the hashtable as a key/value pair.
	 * 
	 * ビットマスクとATRをセットします。
	 */
	public void put(byte[] mask, byte[] atr){
		hashTable.put(mask, atr);
	}
	
	/* (non-Javadoc)
	 * @see opencard.core.service.CardIDFilter#isCandidate(opencard.core.terminal.CardID)
	 */
	public boolean isCandidate(CardID cardID) {
		boolean ret = false;
		
		if (cardID == null) return ret;
		
		try {
			/*
			 * obtains ATR of the card
			 * カードのATR取得
			 */
			byte[] card = cardID.getATR();
			
			byte masked = 0; 
			
			/*
			 * looks for a matching ATR
			 * ATR検索
			 */
			Enumeration em = hashTable.keys();
			while (em.hasMoreElements() && !ret) {
				byte[] mask = (byte[]) em.nextElement();
				byte[] atr = (byte[]) hashTable.get(mask);

				if (atr.length == card.length) {
					int i = 0;
					for (; i < atr.length; i++) {
						/*
						 * masks ATR
						 * マスクする
						 */
						masked = (byte)(card[i] & mask[i]);
						/*
						 * compares ATR
						 * 比較する
						 */
						if(masked!=atr[i]){
							break;
						}
					}
					if(!(i < card.length)){
						ret = true;
					}
				}
			}

		} catch (Throwable e) {
			e.printStackTrace();
		}
		return ret;
	}
}